import {
  world
} from "mojang-minecraft"
import {
  ActionFormData
} from "mojang-minecraft-ui"
import * as names from './namesList';

var personalidade = ["none", "romantico", "extrovertido", "introvertido", "curioso", "antiRomantico", "soAmigo"]

//FUNCTIONS DE CODIGO
function getRandom(max) {
  const nunbRandow = Math.floor(Math.random() * max + 1)
  return nunbRandow
}



//DIALOGOS

const dlg_normalStart = new ActionFormData()
.title("")
.body("")
.button("gui.button.talk")
.button("gui.button.interact")
.button("gui.button.trade")


const dlg_childStart = new ActionFormData()
.title("")
.body("")
.button("gui.button.talk")

const dlg_optConversar = new ActionFormData()
.title("")
.body("")
.button("gui.button.chat")
.button("gui.button.joke")
.button("gui.button.gift")
.button("gui.button.shakehand")
.button("gui.button.tellstory")
.button("gui.button.flirt")
.button("gui.button.hug")
.button("gui.button.kiss")

const dlg_optConversarChild = new ActionFormData()
.title("")
.body("")
.button("gui.button.chat")
.button("gui.button.joke")
.button("gui.button.gift")
.button("gui.button.shakehand")
.button("gui.button.tellstory")

const dlg_optInteragir = new ActionFormData()
.title("")
.body("")
.button("gui.button.chat")
.button("gui.button.int")

const dlg_optTradeFazendeiro = new ActionFormData()
.title("")
.body("")
.button("gui.button.chat")
.button("gui.button.tra")

const dlg_optTradePescador = new ActionFormData()
.title("")
.body("")
.button("gui.button.chat")
.button("gui.button.tra")

const dlg_optTradeFerreiro = new ActionFormData()
.title("")
.body("")
.button("gui.button.chat")
.button("gui.button.tra")

//FUNCTIONS DE DIÁLOGO

function dlg_autoSelect(obj, npc) {
  if (npc.hasTag('casado_' + obj.name) == true) {
    dlg_normalExecute(obj, npc)
  } else if (npc.hasTag('baby') == true && npc.hasTag('filho_' + obj.name) == false) {
    dlg_childExecute(obj, npc)
  } else if (npc.hasTag('adult') == true && npc.hasTag('filho_' + obj.name) == false) {
    dlg_normalExecute(obj, npc)
  } else if (npc.hasTag('adult') == true && npc.hasTag('filho_' + obj.name) == true) {
    dlg_normalExecute(obj, npc)
  } else if (npc.hasTag('baby') == true && npc.hasTag('filho_' + obj.name) == true) {
    dlg_normalExecute(obj, npc)
  }
}

function resultDlgAdult(obj, npc, interacao, filtroTag) {
  var i = getRandom(100)
  if (npc.hasTag(filtroTag + obj.name + '_0') == true || npc.hasTag(filtroTag + obj.name + '_1') == true) {
    if (i <= 70) {
      obj.runCommand('tellraw @s {"rawtext":[{"translate":"adult.' + interacao + '.fail' + getRandom(5) + '"}]}')
    } else if (i >= 71) {
      obj.runCommand('tellraw @s {"rawtext":[{"translate":"adult.' + interacao + '.success' + getRandom(5) + '"}]}')
      i = getRandom(100)
      if (i >= 50) {
        aumentarFunc(obj, npc, filtroTag);
      }
    }
  } else if (npc.hasTag(filtroTag + obj.name + '_2') == true || npc.hasTag(filtroTag + obj.name + '_3') == true) {
    if (i <= 45) {
      obj.runCommand('tellraw @s {"rawtext":[{"translate":"adult.' + interacao + '.fail' + getRandom(5) + '"}]}')
    } else if (i >= 46) {
      obj.runCommand('tellraw @s {"rawtext":[{"translate":"adult.' + interacao + '.success' + getRandom(5) + '"}]}')
      i = getRandom(100)
      if (i >= 50) {
        aumentarFunc(obj, npc, filtroTag);
      }
    }
  } else if (npc.hasTag(filtroTag + obj.name + '_4') == true || npc.hasTag(filtroTag + obj.name + '_5') == true) {
    if (i <= 20) {
      obj.runCommand('tellraw @s {"rawtext":[{"translate":"adult.' + interacao + '.fail' + getRandom(5) + '"}]}')
    } else if (i >= 21) {
      obj.runCommand('tellraw @s {"rawtext":[{"translate":"adult.' + interacao + '.success' + getRandom(5) + '"}]}')
      i = getRandom(100)
      if (i >= 50) {
        aumentarFunc(obj, npc, filtroTag);
      }
    }
  } else {
    if (i <= 74) {
      obj.runCommand('tellraw @s {"rawtext":[{"translate":"adult.' + interacao + '.fail' + getRandom(5) + '"}]}')
    } else if (i >= 75) {
      obj.runCommand('tellraw @s {"rawtext":[{"translate":"adult.' + interacao + '.success' + getRandom(5) + '"}]}')
      i = getRandom(100)
      if (i >= 50) {
        aumentarFunc(obj, npc, filtroTag);
      }
    }
  }
}

function resultDlgchild(obj, npc, interacao, filtroTag) {
  var i = getRandom(100)
  if (npc.hasTag(filtroTag + obj.name + '_0') == true || npc.hasTag(filtroTag + obj.name + '_1') == true) {
    if (i <= 70) {
      obj.runCommand('tellraw @s {"rawtext":[{"translate":"child.' + interacao + '.fail' + getRandom(5) + '"}]}')
    } else if (i >= 71) {
      obj.runCommand('tellraw @s {"rawtext":[{"translate":"child.' + interacao + '.success' + getRandom(5) + '"}]}')
      i = getRandom(100)
      if (i >= 90) {
        aumentarFunc(obj, npc, filtroTag);
      }
    }
  } else if (npc.hasTag(filtroTag + obj.name + '_2') == true || npc.hasTag(filtroTag + obj.name + '_3') == true) {
    if (i <= 45) {
      obj.runCommand('tellraw @s {"rawtext":[{"translate":"child.' + interacao + '.fail' + getRandom(5) + '"}]}')
    } else if (i >= 46) {
      obj.runCommand('tellraw @s {"rawtext":[{"translate":"child.' + interacao + '.success' + getRandom(5) + '"}]}')
      i = getRandom(100)
      if (i >= 90) {
        aumentarFunc(obj, npc, filtroTag);
      }
    }
  } else if (npc.hasTag(filtroTag + obj.name + '_4') == true || npc.hasTag(filtroTag + obj.name + '_5') == true) {
    if (i <= 20) {
      obj.runCommand('tellraw @s {"rawtext":[{"translate":"child.' + interacao + '.fail' + getRandom(5) + '"}]}')
    } else if (i >= 21) {
      obj.runCommand('tellraw @s {"rawtext":[{"translate":"child.' + interacao + '.success' + getRandom(5) + '"}]}')
      i = getRandom(100)
      if (i >= 90) {
        aumentarFunc(obj, npc, filtroTag);
      }
    }
  } else {
    if (i <= 65) {
      obj.runCommand('tellraw @s {"rawtext":[{"translate":"child.' + interacao + '.fail' + getRandom(5) + '"}]}')
    } else if (i >= 66) {
      obj.runCommand('tellraw @s {"rawtext":[{"translate":"child.' + interacao + '.success' + getRandom(5) + '"}]}')
      i = getRandom(100)
      if (i >= 75) {
        aumentarFunc(obj, npc, filtroTag);
      }
    }
  }
}

function aumentarFunc(obj, npc, filtroTag) {
  var i = getRandom(100)
  if (npc.hasTag("romantico") && filtroTag == "IntereseAmoroso" && i >= 30) {
    if (npc.hasTag("soAmigo") && i >= 60) {
      aumentarFuncExe(obj, npc, filtroTag);
    } else {
      aumentarFuncExe(obj, npc, filtroTag);
    }
  } else if (npc.hasTag("antiRomantico") && filtroTag == "IntereseAmoroso" && i >= 60) {
    aumentarFuncExe(obj, npc, filtroTag);
  } else if (npc.hasTag("extrovertido") && filtroTag == "IntereseAmoroso" && i >= 45) {
    aumentarFuncExe(obj, npc, filtroTag);
  } else if (npc.hasTag("introvertido") && filtroTag == "IntereseAmoroso" && i >= 60) {
    aumentarFuncExe(obj, npc, filtroTag);
  } else if (i >= 55) {
    aumentarFuncExe(obj, npc, filtroTag);
  }
}

function aumentarFuncExe(obj, npc, filtroTag) {
  if (npc.hasTag(filtroTag + obj.name + '_5') == true) {
    npc.runCommand('tag @s add ' + filtroTag + obj.name + '_5')
  } else if (npc.hasTag(filtroTag + obj.name + '_4') == true) {
    npc.runCommand('tag @s add ' + filtroTag + obj.name + '_5'); npc.runCommand('tag @s remove ' + filtroTag + obj.name + '_4')
  } else if (npc.hasTag(filtroTag + obj.name + '_3') == true) {
    npc.runCommand('tag @s add ' + filtroTag + obj.name + '_4'); npc.runCommand('tag @s remove ' + filtroTag + obj.name + '_3')
  } else if (npc.hasTag(filtroTag + obj.name + '_2') == true) {
    npc.runCommand('tag @s add ' + filtroTag + obj.name + '_3'); npc.runCommand('tag @s remove ' + filtroTag + obj.name + '_2')
  } else if (npc.hasTag(filtroTag + obj.name + '_1') == true) {
    npc.runCommand('tag @s add ' + filtroTag + obj.name + '_2'); npc.runCommand('tag @s remove ' + filtroTag + obj.name + '_1')
  } else if (npc.hasTag(filtroTag + obj.name + '_0') == true) {
    npc.runCommand('tag @s add ' + filtroTag + obj.name + '_1'); npc.runCommand('tag @s remove ' + filtroTag + obj.name + '_0')
  } else {
    npc.runCommand('tag @s add ' + filtroTag + obj.name + '_0')
  }
}

function dlg_normalExecute(obj, npc) {
  dlg_normalStart.show(obj).then(result => {
    switch (result.selection) {
      case 0: dlg_optConversarExecute(obj, npc);
        break;
      case 1: dlg_optInteragirExecute(obj, npc);
        break;
      case 2: dlg_optTradeExecute(obj, npc);
        break;
    }
  })
}

function dlg_childExecute(obj, npc) {
  dlg_childStart.show(obj).then(result => {
    switch (result.selection) {
      case 0: dlg_optConversarChildExecute(obj, npc);
        break;
    }
  })
}

function dlg_optConversarChildExecute(obj, npc) {
  dlg_optConversarChild.show(obj).then(result => {
    switch (result.selection) {
      case 0: //chat
        resultDlgchild(obj, npc, 'chat', 'IntereseAmizade');
        break;
      case 1: //joke
        resultDlgchild(obj, npc, 'joke', 'IntereseAmizade');
        break;
      case 2: //say gift
        break;
      case 3: //shakehand
        var i = getRandom(100)
        resultDlgchild(obj, npc, 'shakehand', 'IntereseAmizade')
        break;
      case 4: //tellstory
        resultDlgchild(obj, npc, 'tellstory', 'IntereseAmizade')
        break;
    }
  })
}

function dlg_optConversarExecute(obj, npc) {
  dlg_optConversar.show(obj).then(result => {
    switch (result.selection) {
      case 0: //chat
        resultDlgAdult(obj, npc, 'chat', 'IntereseAmizade');
        break;
      case 1: //joke
        resultDlgAdult(obj, npc, 'joke', 'IntereseAmizade');
        break;
      case 2: //say gift
        break;
      case 3: //shakehand
        var i = getRandom(100)
        resultDlgAdult(obj, npc, 'shakehand', 'IntereseAmizade')
        break;
      case 4: //tellstory
        resultDlgAdult(obj, npc, 'tellstory', 'IntereseAmizade')
        break;
      case 5: //flirt
        resultDlgAdult(obj, npc, 'flirt', 'IntereseAmoroso')
        break;
      case 6: //hug
        resultDlgAdult(obj, npc, 'hug', 'IntereseAmizade');
        break;
      case 7: //kiss
        resultDlgAdult(obj, npc, 'kiss', 'IntereseAmoroso');
        break;
    }
  })
}

function dlg_optInteragirExecute(obj, npc) {
  dlg_optInteragir.show(obj).then(result => {
    switch (result.selection) {
      case 0:
        obj.runCommand('tellraw @s {"rawtext":[{"translate":"interaction.marry.fail.lowhearts' + getRandom(5) + '"}]}')
        break;
      case 1:
        break;
    }
  })
}

function dlg_optTradeExecute(obj, npc) {
  if (npc.hasTag('work') && npc.hasTag('fazendeiro')) {
    dlg_optTradeFazendeiro.show(obj).then(result => {
      switch (result.selection) {
        case 0:
          obj.runCommand("say voce sabe conversar")
          break;
        case 1: obj.runCommand("say Trade")
          break;
      }
    })
  } else if (!npc.hasTag('work')) {
    npc.runCommand("say I don't work")
  }
}

//CALL DE DIÁLOGOS

world.events.blockPlace.subscribe(eventData => {
  const player = eventData.player
  const block = eventData.block
})

world.events.entityHurt.subscribe(eventData => {
  if (eventData.hurtEntity.id == "minecraft:player" && eventData.cause == "void" && eventData.damage == 0 //&& eventData.damagingEntity.id == "minecraft:player"
  ) {
    const player = eventData.hurtEntity
    const npc = eventData.damagingEntity

    dlg_autoSelect(player, npc);
  } else if (eventData.hurtEntity.id == "add:fem" && eventData.cause == "void" && eventData.damage == 0 //&& eventData.damagingEntity.id == "add:fem") {
  ) {
    const npc = eventData.damagingEntity
    npc.nameTag = names.nameFem[getRandom(4293)]
    npc.runCommand('tag @s add ' + personalidade[getRandom(7)])
    npc.runCommand('tag @s add ' + personalidade[getRandom(7)])
  } else if (eventData.hurtEntity.id == "add:mas" && eventData.cause == "void" && eventData.damage == 0 //&& eventData.damagingEntity.id == "add:fem") {
  ) {
    const npc = eventData.damagingEntity
    npc.nameTag = names.nameMas[getRandom(1230)]
    npc.runCommand('tag @s add ' + personalidade[getRandom(7)])
    npc.runCommand('tag @s add ' + personalidade[getRandom(7)])
  }
})

world.events.entitySpawn.subscribe(eventData => {
  const spawn = eventData
  if (spawn.id == 'minecraft:villager_v2' || spawn.id == 'minecraft:villager') {
    if (getRandom(10) >= 0) {
      spawn.runCommand('summon add:fem')
    }
    spawn.runCommand('tp ~ ~9999 ~')
  }

})